import processing.serial.*;
import cc.arduino.*;

static final int WINDOW_COLS=640;
static final int WINDOW_ROWS=480;

PGraphics pg;
PFont f;

int pirPin=3; // PIN collegato al sensore PIR
int greenLedPin = 4; // PIN collegato al LED verde
int redLedPin = 2; // PIN collegato al LED rosso
Arduino arduino; // oggetto di tipo Arduino: serve a dialogare con la board
boolean arduinoCheck=false; // booleano: true -> Arduino collegato, false -> Arduino assente

void setup() {
  surface.setSize(WINDOW_COLS,WINDOW_ROWS);
  pg = createGraphics(WINDOW_COLS, WINDOW_ROWS);
  f = createFont("Arial",16,true);

  try {
    println((Object[])Arduino.list());
    arduino = new Arduino(this, Arduino.list()[4], 57600);
    arduino.pinMode(greenLedPin, Arduino.OUTPUT);
    arduino.digitalWrite(greenLedPin, Arduino.LOW);
    arduino.pinMode(redLedPin, Arduino.OUTPUT);
    arduino.digitalWrite(redLedPin, Arduino.LOW);
    arduino.pinMode(pirPin,Arduino.INPUT);
    arduinoCheck=true;
  }
  catch(Exception e) {
    println("Error: "+e.toString());
    arduinoCheck=false;
  }
  
  delay(5000);
}

void draw() {
  background(#FFFFFF);
  pg.beginDraw();
  pg.clear();
  pg.smooth();
  pg.fill(0);
  pg.textFont(f);
  pg.textAlign(RIGHT);
  pg.text("Green LED",WINDOW_COLS/4,WINDOW_ROWS/4); 
  pg.text("Red LED",WINDOW_COLS/4,WINDOW_ROWS/4*3);
  pg.rectMode(CENTER);

  if(arduinoCheck) {
    int pirSignal=arduino.digitalRead(pirPin);
    
    if(pirSignal==Arduino.HIGH) {
      arduino.digitalWrite(redLedPin,Arduino.HIGH);
      arduino.digitalWrite(greenLedPin,Arduino.LOW);
      pg.fill(255,255,255);
      pg.rect(WINDOW_COLS/2,WINDOW_ROWS/4,100,100);
      pg.fill(255,0,0);
      pg.rect(WINDOW_COLS/2,WINDOW_ROWS/4*3,100,100);
    }
    else {
      arduino.digitalWrite(greenLedPin,Arduino.HIGH);
      arduino.digitalWrite(redLedPin,Arduino.LOW);
      pg.fill(0,255,0);
      pg.rect(WINDOW_COLS/2,WINDOW_ROWS/4,100,100);
      pg.fill(255,255,255);
      pg.rect(WINDOW_COLS/2,WINDOW_ROWS/4*3,100,100);
      pg.fill(255);
    }
  }

  pg.endDraw();
  
  image(pg,0,0);
}
